<?php
App::uses('AppController', 'Controller');
class SourceEmailsController extends AppController {
	public $helpers = array('Html', 'Session','Text','Fck', 'Js','thumbnail','Common');
	public $components=array('Auth','Cookie','Email');
	public $uses = array('SourceEmail','EmailTemplate','ApplicationSetting'); 
	
	public $paginate = array(
        'limit' => 20,
        'order' => array(
            'SourceEmail.id' => 'desc'
        )
    );
	
	public function beforeFilter() {
        parent::beforeFilter();
	}
	public function admin_index($id = null) {
		
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Admin'));
		$this->SourceEmail->recursive = 0;
		if ($this->request->is('post') && !empty($this->request->data['task_value'])) {
			if($this->request->data['task_value']=='DeActive')
				$this->SourceEmail->updateAll(array("SourceEmail.status"=>'0'),array("SourceEmail.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Active')
				$this->SourceEmail->updateAll(array("SourceEmail.status"=>'1'),array("SourceEmail.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishome')
				$this->SourceEmail->updateAll(array("SourceEmail.show_home"=>'1'),array("SourceEmail.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Ishomenot')
				$this->SourceEmail->updateAll(array("SourceEmail.show_home"=>'0'),array("SourceEmail.id"=>$this->request->data['frmList']['ID']));
			else if($this->request->data['task_value']=='Delete')
				$this->SourceEmail->deleteAll(array('SourceEmail.id' => $this->request->data['frmList']['ID']), false);
			unset($this->request->data);
		}
		//pr($this->data);die;
		if(isset($this->data['SourceEmail']['title']) && $this->data['SourceEmail']['title']!='') $title = $this->data['SourceEmail']['title'];	
		else if(isset($this->params['named']['title']) && $this->params['named']['title']!='') $title = $this->request->data['SourceEmail']['title']=$this->params['named']['title'];
		
		$conditions = array(); 
		$pagingArgs = array(); 
		
		if(!empty($title))
		{
			$conditions['SourceEmail.title LIKE '] = '%'.$title.'%';
			$pagingArgs['title'] = $title;
		}
		$this->set("pagingArgs",$pagingArgs);
				
		$limit=$this->get_application_setting('result_limit');		
		$this->paginate = array(
			  'limit'=>$limit,
			  'maxLimit' => 100000,
			  'order'=>array('SourceEmail.id'=>'DESC'),
			  'conditions'=>$conditions
		 );
		$rows =  $this->paginate();
		$this->set('source_emails', $rows);
	}
	public function admin_add() {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Add SourceEmail'));
		if ($this->request->is('post')) {
			$this->SourceEmail->create();	
			$pre_title_check = $this->SourceEmail->find("count",array("conditions"=>array("SourceEmail.title"=>$this->request->data['SourceEmail']['title'])));
			if($pre_title_check==0)
			{
				$this->request->data['SourceEmail']['date_time']			=	date("Y-m-d H:i:s");
				if ($res=$this->SourceEmail->save($this->request->data['SourceEmail'])){
					$this->Session->setFlash(__('Source Email has been addedd successfully.'), 'default', array('class' => 'success'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('Source Email could not be addedd.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			} 
			else {
				$this->Session->setFlash(__('Source Email title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			
		}
	}
	public function admin_edit($id = null) {
		$this->checkSubAdmin();
		$this->set('title_for_layout', __('Edit SourceEmail'));
		$this->SourceEmail->id = $id;
		$selected = "";
		
		$driver_detail = $this->SourceEmail->find("first",array("conditions"=>array("SourceEmail.id"=>$id)));
		$this->set("driver_detail",$driver_detail);
		$this->set("id",$id);
		if (!$this->SourceEmail->exists()) {
			throw new NotFoundException(__('Invalid source_email'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$this->request->data['SourceEmail']['id']=$id;		
			$pre_title_check = $this->SourceEmail->find("count",array("conditions"=>array("SourceEmail.title"=>$this->request->data['SourceEmail']['title'],"SourceEmail.id <>"=>$id)));
			if($pre_title_check==0)
			{
				if ($res=$this->SourceEmail->saveAll($this->request->data['SourceEmail'])) {
					$this->Session->setFlash(__('Source Email has been updated successfully.'), 'default', array('class' => 'success'));
				} else {
					$this->Session->setFlash(__('Source Email could not be updated.'), 'default', array('class' => 'error'));
					$this->redirect(array('action' => 'index'));
				}
			}
			else
			{
				$this->Session->setFlash(__('Source Email title is already used'), 'default', array('class' => 'error'));
				$this->redirect(array('action' => 'index'));
			}
			$this->request->data = $this->SourceEmail->read(null, $id);
			$this->redirect(array('action' => 'index'));
		} else {
			$this->request->data = $this->SourceEmail->read(null, $id);
		}	
		$this->set('selected', $selected);
	}
	public function admin_delete($id = null) {
		$this->checkAdmin();
		$this->SourceEmail->id = $id;
		if (!$this->SourceEmail->exists()) {
			throw new NotFoundException(__('Invalid Source Email'));
		}
		else
		{
			$source_emails = $this->SourceEmail->read(null, $id);
			if(!empty($source_emails['SourceEmail']['image']))
			{
				unlink(WWW_ROOT.'source_email/'.$source_emails['SourceEmail']['image']);
			}
			if ($this->SourceEmail->delete()) {
				$this->Session->setFlash(__('Source Email has been deleted successfully.'), 'default', array('class' => 'success'));
				$this->redirect(array('action' => 'index'));
			}
		}
		$this->Session->setFlash(__('Source Email could not be successfully.'), 'default', array('class' => 'success'));
		$this->redirect(array('action' => 'index'));
	}
}
